(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     47568,       1163]
NotebookOptionsPosition[     46719,       1126]
NotebookOutlinePosition[     47072,       1142]
CellTagsIndexPosition[     47029,       1139]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Euler scheme for geometric BM", "Title",
 CellChangeTimes->{{3.673837696780387*^9, 3.67383770436876*^9}}],

Cell[CellGroupData[{

Cell["Weak local error of second order", "Chapter",
 CellChangeTimes->{{3.6742261791368017`*^9, 3.67422619546509*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Expectation", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "1", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "'"}], "[", "1", "]"}], 
         RowBox[{"(", 
          RowBox[{"y", "-", "1"}], ")"}]}], "+", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"f", "''"}], "[", "1", "]"}], "2"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"y", "-", "1"}], ")"}], "2"]}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "'''"}], "[", "\[Xi]", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"y", "-", "1"}], ")"}], "3"]}]}], ",", 
       RowBox[{"y", "\[Distributed]", 
        RowBox[{
         RowBox[{"GeometricBrownianMotionProcess", "[", 
          RowBox[{"\[Mu]", ",", "\[Sigma]", ",", "1"}], "]"}], "[", "t", 
         "]"}]}]}], "]"}], "-", 
     RowBox[{"Expectation", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "1", "]"}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "'"}], "[", "1", "]"}], 
         RowBox[{"(", 
          RowBox[{"y", "-", "1"}], ")"}]}], "+", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"f", "''"}], "[", "1", "]"}], "2"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"y", "-", "1"}], ")"}], "2"]}], "+", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "'''"}], "[", "\[Xi]", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"y", "-", "1"}], ")"}], "3"]}]}], ",", 
       RowBox[{"y", "\[Distributed]", 
        RowBox[{"NormalDistribution", "[", 
         RowBox[{
          RowBox[{"1", "+", 
           RowBox[{"\[Mu]", " ", "t"}]}], ",", 
          RowBox[{"\[Sigma]", 
           SqrtBox["t"]}]}], "]"}]}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.674225164671557*^9, 3.67422520260863*^9}, {
  3.6742259323870907`*^9, 3.674225999590596*^9}, {3.6742260481934*^9, 
  3.6742261514635143`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["\[Mu]", "2"], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "1", "]"}]}], "+", 
      RowBox[{"\[Mu]", " ", 
       SuperscriptBox["\[Sigma]", "2"], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "1", "]"}]}], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox["\[Sigma]", "4"], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "1", "]"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["\[Sigma]", "4"], " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", "3", ")"}],
          Derivative],
         MultilineFunction->None], "[", "\[Xi]", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["t", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "t", "]"}], "3"],
    SeriesData[$CellContext`t, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`t, 0, {
   Rational[1, 2] $CellContext`\[Mu]^2 
     Derivative[1][$CellContext`f][
      1] + $CellContext`\[Mu] $CellContext`\[Sigma]^2 
     Derivative[2][$CellContext`f][1] + 
    Rational[1, 4] $CellContext`\[Sigma]^4 Derivative[2][$CellContext`f][1] + 
    3 $CellContext`\[Sigma]^4 
     Derivative[3][$CellContext`f][$CellContext`\[Xi]]}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.6742261132267647`*^9, 3.674226152032724*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some simulated sample paths", "Chapter",
 CellChangeTimes->{{3.673837710006036*^9, 3.673837726225658*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "t", ",", "w", ",", 
       RowBox[{"x0", "=", "1"}], ",", 
       RowBox[{"t0", "=", "0"}], ",", "ExactProcess", ",", "SimulatedProcess",
        ",", 
       RowBox[{"StepSize", "=", 
        RowBox[{"T", "/", "NumberOfSteps"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SeedRandom", "[", "1", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ExactProcess", "=", 
       RowBox[{"ItoProcess", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[DifferentialD]", 
           RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", 
          RowBox[{
           RowBox[{"x", "[", "t", "]"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Mu]", " ", 
              RowBox[{"\[DifferentialD]", "t"}]}], "+", 
             RowBox[{"\[Sigma]", " ", 
              RowBox[{"\[DifferentialD]", 
               RowBox[{"w", "[", "t", "]"}]}]}]}], ")"}]}]}], ",", 
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "t0"}], "}"}], ",", 
         RowBox[{"w", "\[Distributed]", 
          RowBox[{"WienerProcess", "[", "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimulatedProcess", "=", 
       RowBox[{"RandomFunction", "[", 
        RowBox[{"ExactProcess", ",", 
         RowBox[{"{", 
          RowBox[{"t0", ",", "T", ",", "StepSize"}], "}"}], ",", 
         "NumberOfPaths", ",", 
         RowBox[{"Method", "\[Rule]", "\"\<EulerMaruyama\>\""}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"ListLinePlot", "[", "SimulatedProcess", "]"}]}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Mu]", ",", "1"}], "}"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Sigma]", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"T", ",", "1"}], "}"}], ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NumberOfSteps", ",", "10"}], "}"}], ",", "1", ",", "1000", ",",
      "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NumberOfPaths", ",", "10"}], "}"}], ",", "1", ",", "100", ",", 
     "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.673778590513817*^9, 3.67377861483887*^9}, {
   3.673778657718877*^9, 3.673778909321422*^9}, 3.673778954815772*^9, {
   3.67377902540823*^9, 3.673779045567316*^9}, {3.673786726249818*^9, 
   3.6737867342403193`*^9}, {3.673786786427165*^9, 3.673786796314828*^9}, {
   3.673787171968391*^9, 3.673787225144125*^9}, {3.6738036092277327`*^9, 
   3.673803619282442*^9}, {3.673803828043398*^9, 3.673803838818033*^9}, {
   3.673804119279367*^9, 3.6738042036614723`*^9}, {3.67380478510538*^9, 
   3.673804791294257*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`NumberOfPaths$$ = 
    10, $CellContext`NumberOfSteps$$ = 10, $CellContext`T$$ = 
    1, $CellContext`\[Mu]$$ = 1, $CellContext`\[Sigma]$$ = 1, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Mu]$$], 1}, -1, 1}, {{
       Hold[$CellContext`\[Sigma]$$], 1}, 0, 2}, {{
       Hold[$CellContext`T$$], 1}, 0, 10}, {{
       Hold[$CellContext`NumberOfSteps$$], 10}, 1, 1000, 1}, {{
       Hold[$CellContext`NumberOfPaths$$], 10}, 1, 100, 1}}, 
    Typeset`size$$ = {360., {113., 117.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[Mu]$36470$$ = 0, $CellContext`\[Sigma]$36471$$ = 
    0, $CellContext`T$36472$$ = 0, $CellContext`NumberOfSteps$36473$$ = 
    0, $CellContext`NumberOfPaths$36474$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`NumberOfPaths$$ = 
        10, $CellContext`NumberOfSteps$$ = 10, $CellContext`T$$ = 
        1, $CellContext`\[Mu]$$ = 1, $CellContext`\[Sigma]$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Mu]$$, $CellContext`\[Mu]$36470$$, 0], 
        Hold[$CellContext`\[Sigma]$$, $CellContext`\[Sigma]$36471$$, 0], 
        Hold[$CellContext`T$$, $CellContext`T$36472$$, 0], 
        Hold[$CellContext`NumberOfSteps$$, $CellContext`NumberOfSteps$36473$$,
          0], 
        Hold[$CellContext`NumberOfPaths$$, $CellContext`NumberOfPaths$36474$$,
          0]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`x$, $CellContext`t$, $CellContext`w$, \
$CellContext`x0$ = 1, $CellContext`t0$ = 
         0, $CellContext`ExactProcess$, $CellContext`SimulatedProcess$, \
$CellContext`StepSize$ = $CellContext`T$$/$CellContext`NumberOfSteps$$}, 
        SeedRandom[1]; $CellContext`ExactProcess$ = ItoProcess[DifferentialD[
             $CellContext`x$[$CellContext`t$]] == \
$CellContext`x$[$CellContext`t$] ($CellContext`\[Mu]$$ 
              DifferentialD[$CellContext`t$] + $CellContext`\[Sigma]$$ 
              DifferentialD[
                $CellContext`w$[$CellContext`t$]]), 
           $CellContext`x$[$CellContext`t$], {$CellContext`x$, \
$CellContext`x0$}, {$CellContext`t$, $CellContext`t0$}, 
           Distributed[$CellContext`w$, 
            WienerProcess[]]]; $CellContext`SimulatedProcess$ = 
         RandomFunction[$CellContext`ExactProcess$, {$CellContext`t0$, \
$CellContext`T$$, $CellContext`StepSize$}, $CellContext`NumberOfPaths$$, 
           Method -> "EulerMaruyama"]; 
        ListLinePlot[$CellContext`SimulatedProcess$]], 
      "Specifications" :> {{{$CellContext`\[Mu]$$, 1}, -1, 
         1}, {{$CellContext`\[Sigma]$$, 1}, 0, 2}, {{$CellContext`T$$, 1}, 0, 
         10}, {{$CellContext`NumberOfSteps$$, 10}, 1, 1000, 
         1}, {{$CellContext`NumberOfPaths$$, 10}, 1, 100, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {213., 218.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.673803796417194*^9, {3.67380384613192*^9, 3.673803874768906*^9}, 
   3.673804207772252*^9, 3.6738047971558657`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["First-order convergence of the mean", "Chapter",
 CellChangeTimes->{{3.673837737903862*^9, 3.67383774724719*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Mu]", "=", "1"}], ",", 
     RowBox[{"\[Sigma]", "=", "1"}], ",", 
     RowBox[{"T", "=", "1"}], ",", 
     RowBox[{"NumberOfPaths", "=", "100000"}], ",", "x", ",", "xx", ",", "t", 
     ",", "w", ",", 
     RowBox[{"x0", "=", "1"}], ",", 
     RowBox[{"t0", "=", "0"}], ",", "ExactProcess", ",", "ExactMean", ",", 
     "SimulatedProcess", ",", "SimulatedMean", ",", "NumberOfSteps", ",", 
     "StepSize", ",", "WeakError", ",", "TableOfWeakErrors", ",", 
     "LinearModel", ",", "RegressionLine"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ExactProcess", "=", 
     RowBox[{"ItoProcess", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[DifferentialD]", 
         RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Mu]", " ", 
            RowBox[{"\[DifferentialD]", "t"}]}], "+", 
           RowBox[{"\[Sigma]", " ", 
            RowBox[{"\[DifferentialD]", 
             RowBox[{"w", "[", "t", "]"}]}]}]}], ")"}]}]}], ",", 
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "t0"}], "}"}], ",", 
       RowBox[{"w", "\[Distributed]", 
        RowBox[{"WienerProcess", "[", "]"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ExactMean", "=", 
     RowBox[{"Mean", "[", 
      RowBox[{"ExactProcess", "[", "T", "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"TableOfWeakErrors", "=", 
     RowBox[{"ParallelTable", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"NumberOfSteps", "=", 
         SuperscriptBox["2", "k"]}], ";", "\[IndentingNewLine]", 
        RowBox[{"StepSize", "=", 
         RowBox[{"T", "/", "NumberOfSteps"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"SimulatedMean", "=", 
         RowBox[{"Mean", "[", 
          RowBox[{
           RowBox[{"RandomFunction", "[", 
            RowBox[{"ExactProcess", ",", 
             RowBox[{"{", 
              RowBox[{"t0", ",", "T", ",", "StepSize"}], "}"}], ",", 
             "NumberOfPaths", ",", 
             RowBox[{"Method", "\[Rule]", "\"\<EulerMaruyama\>\""}]}], "]"}], 
           "[", "T", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"WeakError", "=", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"ExactMean", "-", "SimulatedMean"}], "]"}], "/", 
          "ExactMean"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"StepSize", ",", "WeakError"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", "5"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"LinearModel", "=", 
     RowBox[{"LinearModelFit", "[", 
      RowBox[{
       RowBox[{"Log", "[", "TableOfWeakErrors", "]"}], ",", "xx", ",", "xx"}],
       "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"RegressionLine", "=", 
     RowBox[{"LogLogPlot", "[", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"LinearModel", "[", 
         RowBox[{"Log", "[", "x", "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"TableOfWeakErrors", "\[LeftDoubleBracket]", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "\[RightDoubleBracket]"}], ",", 
         RowBox[{"TableOfWeakErrors", "\[LeftDoubleBracket]", 
          RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "}"}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"ListLogLogPlot", "[", "TableOfWeakErrors", "]"}], ",", 
      "RegressionLine", ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"\"\<slope: \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{"LinearModel", "[", "\"\<BestFitParameters\>\"", "]"}], 
          "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "]"}]}]}]}],
      "]"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.6738054319059763`*^9, 3.673805463103984*^9}, {
   3.6738054973450117`*^9, 3.6738055037790937`*^9}, {3.673805619716793*^9, 
   3.6738056490326777`*^9}, {3.673806578985017*^9, 3.673806585521866*^9}, {
   3.673806659582046*^9, 3.6738068150241127`*^9}, {3.673806878551659*^9, 
   3.673806883123096*^9}, {3.67380693014537*^9, 3.673807022702743*^9}, {
   3.673807216043762*^9, 3.673807223302846*^9}, 3.6738073432625637`*^9, 
   3.673808114503924*^9, {3.6738081836906567`*^9, 3.6738082142279778`*^9}, {
   3.673808307860548*^9, 3.673808308036338*^9}, {3.673808352414689*^9, 
   3.673808425247245*^9}, {3.6738085535878563`*^9, 3.673808595400917*^9}, {
   3.673808735657854*^9, 3.6738087460965757`*^9}, {3.673808791613937*^9, 
   3.673808847621152*^9}, 3.6738088970455313`*^9, {3.673809235424966*^9, 
   3.6738092969456367`*^9}, {3.673836774259727*^9, 3.6738367752465153`*^9}, {
   3.6738369077026443`*^9, 3.673836908948093*^9}, 3.673836945230328*^9, {
   3.6738374095740957`*^9, 3.673837409724399*^9}, {3.673837555768355*^9, 
   3.6738376273982143`*^9}, {3.674222459227871*^9, 3.674222480037141*^9}, {
   3.674222548808539*^9, 3.6742225578815804`*^9}, {3.674222682917108*^9, 
   3.6742227460330267`*^9}, {3.674222830447275*^9, 3.674222906385841*^9}, {
   3.674222984730097*^9, 3.6742229852084084`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.012833333333333334`], AbsoluteThickness[1.6], 
      PointBox[{{-0.6931471805599453, -1.7620971246186206`}, \
{-1.3862943611198906`, -2.2475753513396137`}, {-2.0794415416798357`, \
-2.849743717838913}, {-2.772588722239781, -3.6084682384251874`}, \
{-3.4657359027997265`, -4.791661498522407}}]}, {}}, {}}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVxX041AccAPCfO865X+deQljoIo0J1UKsMU2Tl5yXZKfSpGYlL62ZIW9p
QozGbguF3kT1yKNQ+H4VUjM9RrXHnVPh5yVvqfA7b9v++DwfUXCEzyEGQRCe
//l/a+mamq46EhNlRGKriRB1vQr7tWtJnDyn0/fCWIiEui4/4C6JB9wsHEfW
CrEzmvedvIrEL+r2LJMiIR73X9IfrCCRKb2V6G0gxGptecJMEYlpPnuT5NpC
tM2T7tBLIfGXxzXJ0ywhfp6r+Xy/G4nFNeGphiMCzGibGEvv5KBHt93bqDIB
rv9h8vXdAxyMtDbI1AwTIM9K5aj+tAY2iNIO9VgL8FNTtTcGsRqY5+t5rWSK
jxXnzNyMORrY37xBp6qaj0GfOZW05bCxPvrIWMP3fNz37tuMy3psbGywYNKb
+XjTqNInpVwdI88Is5VTPLRPHxUSm9QxRid1gI7goV6oS1ViEwsjjc3zM2c1
0dnvdv8WXxbek8ha45I18fpJHvesTA11V7o8ClbRxG9WZ2sPHFXDULd+kTyd
i/5zS9ryaVV8wrB392Bz8bdXSWWceFVMGCz4oJ++Aj92MtZ34KqiyVeblHHC
FTgrqzlF5jNRbpb8V1cuiavGw9p7TZiYmqk636BH4gkHLa64goHO4U6zF6Qc
XC1t75vbzEBxXNoJxSoO6oReyb3UrIJidaZHZbEGekZHOky4q2CIlu10jJEG
PqMDm+1lBB4uvjjddZWNZRkBfQ1hBNb7rzyRZc3GiNvZA00jy2CS7di8rVId
N9rdbCM5yxD/ZXF4kp06hm+tLMxftQSjcXVDdXdZ6LT7Wd5Zs0W43tv7ytuW
hXcCHdzT3BcgoNHGJh7V8Ir89NsmyTx8tMb16yJHNbRzFfgTsUroILKfix+p
4oGORkVFEQ3dZF93sLcqMp+K90hvzcG4dLjkaCcTd94zzv756SzMlJo+ZkmY
qLFGVn2ndwa0rAzg938YGBbZ9cfw/AdYa+/KawhiYIhsvPSM4QdIiUh46Tii
gi9wrCDU8j3MrDuWVBeqguM5Fr4eu96BJDAntmWKwJMysTIicBr+FoRtbwsn
8JKTtIU49hbsBq/o+yqWISzH0Cs/ewpuXJYH208twf47Wrld9pOw83CqK29i
EcyNwonUmHFoWZf/mr24AKJGslYT3gC1tT4B+AvA9TnupfdyBCzFfrUH+fPg
eF9y8BPRMASE7L5qIVLCrnrnB0F6w1AaWZhMGChhb4O5KE8wDBPx/Xu7dZUQ
A0rFgsowpORHrYznK6Hq4XlJx+shuNWalfTnMg2m7T3eUZeHgGXWKjmioIHb
K3GqWT8E1eM2vLICGlYrnC++MRqCJfrkaJyUBvM+8yUj3SHYyWpp8fqVhh2v
lPfPsIdAYegbP5tBQ9LgeVvJCAUcccTIjlga3o/3WC6WUxBcde3hYAANjMkH
WRsvUXCjceJCnR8NgqnysUMFFMw+2RKbJabBcjq2vCOTgqz+h9ZbXGkIndE3
LQ6joFbrZVGqLQ3Rs4zT3SEUMEXrfwrYTMPpudF+9j4Kdm0I97OwoqFUea8k
ypOCAZcFTrcpDZXzpcRVFwqsfLZT19bS0LiQEdSzjYLY/RlNcYY0tC8eb9S0
oaD5SGehlz4NsiWJwXZLCvg/6sYY69DwLyISgu8=
       "]]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-3.56772240202274, -5.011549235338006},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{{{-4.605170185988091, 
       FormBox["0.01`", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.912023005428146, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.02\"", 0.02, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-5.115995809754082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.961845129926823, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.8283137373023015`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.710530701645918, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.199705077879927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.506557897319982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.2188758248682006`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.659260036932778, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.8971199848858813`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, Automatic}, {{{-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.20\"", 0.2, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.50\"", 0.5, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.506557897319982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-3.2188758248682006`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.659260036932778, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.8971199848858813`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
          "CacheGraphics" -> False], 
         Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Log, Exp}, {Log, Exp}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Log, Exp}, {Log, Exp}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Log, Exp}, {Log, Exp}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Log, Exp}, {Log, Exp}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"slope: 1.07048\"", TraditionalForm],
  PlotRange->{{-3.523498167846389, -0.6931471805599453}, {-4.959970630405951, \
-1.7620971246186206`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{{{-2.995732273553991, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
       AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.20\"", 0.2, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.50\"", 0.5, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
       AbsoluteThickness[0.1]}}, {-3.912023005428146, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-3.506557897319982, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-3.2188758248682006`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.659260036932778, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-1.8971199848858813`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.916290731874155, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {0., 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}}, {{-4.605170185988091, 
      FormBox["0.01`", TraditionalForm], {0.01, 0.}, {
       AbsoluteThickness[0.1]}}, {-3.912023005428146, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.02\"", 0.02, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.995732273553991, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}, {
       AbsoluteThickness[0.1]}}, {-5.298317366548036, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-5.115995809754082, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-4.961845129926823, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-4.8283137373023015`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-4.710530701645918, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-4.199705077879927, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-3.506557897319982, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-3.2188758248682006`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.659260036932778, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-1.8971199848858813`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.916290731874155, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}, {0., 
      FormBox[
       InterpretationBox[
        StyleBox[
         GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> Baseline], 
         "CacheGraphics" -> False], 
        Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
       AbsoluteThickness[0.1]}}}}]], "Output",
 CellChangeTimes->{{3.673808431816312*^9, 3.673808438717855*^9}, 
   3.673808601580621*^9, 3.673808752089528*^9, {3.673808797453046*^9, 
   3.673808808082324*^9}, {3.6738088387309313`*^9, 3.6738088532026367`*^9}, 
   3.6738089026917057`*^9, {3.673809282618059*^9, 3.673809302940304*^9}, 
   3.673836787511003*^9, 3.6738369146681023`*^9, 3.6738369944539833`*^9, 
   3.67383705883735*^9, 3.6738374613058147`*^9, 3.673837544697302*^9, 
   3.6738376818992043`*^9, 3.6742226489921227`*^9, 3.674222795591537*^9, 
   3.674222954566856*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 11, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 111, 1, 92, "Title"],
Cell[CellGroupData[{
Cell[716, 27, 118, 1, 65, "Chapter"],
Cell[CellGroupData[{
Cell[859, 32, 2194, 66, 143, "Input"],
Cell[3056, 100, 1657, 46, 48, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4762, 152, 112, 1, 65, "Chapter"],
Cell[CellGroupData[{
Cell[4899, 157, 3063, 78, 182, "Input"],
Cell[7965, 237, 3906, 72, 448, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11920, 315, 119, 1, 65, "Chapter"],
Cell[CellGroupData[{
Cell[12064, 320, 5475, 120, 390, "Input"],
Cell[17542, 442, 29137, 679, 255, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

